﻿var panelAttributes = {
    context: $(".v-panelAttributes"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".v-panelAttributesTable", this.context).a4datatable({
            height: "full",
            stateKey: "SettingsPanelAttributes",
            ajaxAction: a4.getAction("GetPanelAttributes", "Home", "Panel"),
            columns: [
                { "Name": "Id", "Title": resources.Id },
                { "Name": "Name", "Title": resources.Name, "HideInSelector": true },
                { "Name": "Type", "Title": resources.Type },
                { "Name": "ImportMergeAllowed", "Data": "ImportMergeAllowedLabel", "Title": resources.AllowUpdateFromImport },
                { "Name": "IsAnonymizable", "Data": "IsAnonymizableLabel", "Title": resources.PII },
                { "Name": "IsRequired", "Data": "IsRequiredLabel", "Title": resources.Required },
                { "Name": "EnableAutoUpdate", "Data": "EnableAutoUpdateLabel", "Title": resources.EnableAutoUpdate },
                { "Name": "ModifiedBy", "Title": resources.ModifiedBy },
                { "Name": "ModifiedOn", "Title": resources.ModifiedOn }
            ],
            toolBarItems: panelAttributes.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                if (action == "delete") {
                    panelAttributes.deleteItems(_.pluck(rows, "Id"));
                }
            },
            contextMenuItems: panelAttributes.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "properties") {
                    modalDialog.showWindow(a4.getAction("EditAttribute", "Home", "Panel", { id: row.Id }), 600, 600, { afterClose: function () { panelAttributes.refreshDataTable(); } });
                }
                else if (action == "delete") {
                    panelAttributes.deleteItems(row.Id);
                }
            },
            localizableTexts: { "Search": resources.SearchPanelAttribute }
        });
    },
    bindEvents: function () {
        panelAttributes.context.on("click", ".h-importAttributes", function () {
            modalDialog.showWindow(a4.getAction("ImportAttributes", "Home", "Panel"), 450, 650, { afterClose: function () { panelAttributes.refreshDataTable(); } });
        });

        panelAttributes.context.on("click", ".h-addAttribute", function () {
            modalDialog.showWindow(a4.getAction("EditAttribute", "Home", "Panel"), 600, 600, { afterClose: function () { panelAttributes.refreshDataTable(); } });
        });
    },
    refreshDataTable: function () {
        this.datatable.a4datatable("refresh");
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeleteAttributes", "Home", "Panel"), { ids: items },
                function (result) {
                    panelAttributes.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    canModifyPanel: $("#CanModifyPanel").val() == "True",
    getToolBarItems: function () {
        var items = [];

        if (this.canModifyPanel) {
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    },
    getContextMenuItems: function () {
        var items = [];

        if (this.canModifyPanel) {
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "properties", "Label": resources.Properties });
        }

        return items;
    }
}

$(document).ready(function () {
    if (panelAttributes.context.length > 0) {
        panelAttributes.initializeDataTable();
        panelAttributes.bindEvents();
    }
});